package net.slreynolds.montyhall

import scala.actors._
import scala.util.Random

class Contestant(aName: String) extends DebugActor(aName) {
   val numDoors = 3
   val random = new Random
   var firstPick: Int = _
   
   def chat(msg:String) = {
     println(name + ":\t" + msg)
   }  
   
   def act() {
       react {
          case PickADoor(_)  =>
             firstPick = chooseARandomDoor
             sender ! DoorPick(name,firstPick)  
             act()
          case EmptyDoor(_,empty)  =>
             sender ! DoorPick(name,chooseANewDoor(empty)) 
             act()
          case YouWon(_) =>
             chat("Yippie! I'm going to the casino to celebrate.")
             //exit
          case YouLose(_) =>
             chat("Rats! I want to try again.")
             //exit
          case move : Move =>
             chat("received move " + move)
             act()
          case x =>
             chat("oops, received an x " + x) 
             act()
       }
   }
   
   // pick a random door
   def chooseARandomDoor() : Int = {
      val pick =  random.nextInt(numDoors)
      chat("I'll pick door number " + pick)
      pick
   }  
   
   // pick a new door that isn't our first pick or the
   // empty door that Monty just showed us
   def chooseANewDoor(emptyDoor: Int) : Int = {
      var doors =  List.range(0,numDoors)
      doors = doors.filterNot(_ == emptyDoor)
      doors = doors.filterNot(_ == firstPick)
      val pick =  doors.head
      chat("I'll change to door number " + pick)
      pick
   }
}
