package net.slreynolds.montyhall

import scala.actors._

abstract class Move(from: String) {
    override def toString = "From " + from + ", " + this.getClass().getSimpleName()
}
case class StartGame(from: String, guest: DebugActor) extends Move(from) {
    override def toString = super.toString() +", Guest is " + guest.name
}
case class PickADoor(from: String) extends Move(from)
case class DoorPick(from: String, door:Int) extends Move(from) {
    override def toString = super.toString() +", Pick is door # " + door
}
case class EmptyDoor(from: String, door:Int) extends Move(from){
    override def toString = super.toString() +", Empty door is # " + door
}
case class YouWon(from: String) extends Move(from)
case class YouLose(from: String) extends Move(from) 
   

abstract class DebugActor(val name: String) extends Actor {
    override def !(msg: Any) {
        println("-->[[ Sending To " + name  + ", " + msg + " ]]")
        super.!(msg)
    }
}

object GameShow {
   def chat(msg:String) = {
     println("Show:\t" + msg)
   }
   
   def main(args : Array[String]) : Unit = {
     val monty = new MontyHall
     monty.start
     val guest = new Contestant("Jim")
     guest.start
     chat("OK Monty, start the game")
     monty ! new StartGame("Game Show",guest)
   }
}
