package net.slreynolds.montyhall

import scala.actors._
import scala.util.Random

class GameState(door: Int, newGuest: DebugActor) {
  // move this num door stuff to a Trait
  val numDoors = 3
  if (door < 0 || door >= numDoors)
    throw new IllegalArgumentException("door out of legal range")
  val doorNum = door
  val guest = newGuest
  var firstRound = true
}

class MontyHall extends DebugActor("Monty Hall") {
   val numDoors = 3
   val random = new Random 
   var gameState : GameState = _
   

   def chat(msg:String) = {
     println("Monty:\t" + msg)
   }  
   
   def act() {
       val monty = "Monty Hall"
       react {
          case  StartGame(_,guest)  =>
            startGame(guest)
            guest ! PickADoor(monty)
            act()
          case DoorPick(_,pick)  =>
            if (gameState.firstRound) {
                sender ! EmptyDoor(monty,chooseEmptyDoor)
            }
            else {
                sender ! win(pick)
                exit
            }    
            gameState.firstRound = false
            act()
          case move : Move =>
            chat("received move " + move)
            act()
          case x =>
            chat("oops, received an x " + x)
            act()
       }
   }
   
    
   /* Start the game: create the game state
    */
   def startGame(guest: DebugActor) {
      chat("Right, let's start. " + guest.name + ", please pick a door.")
      gameState = new GameState(chooseADoor,guest)
      chat("...ssshhh, don't tell " + guest.name + ", the car is behind door " +
         gameState.doorNum + " ....")
   }
   
   /* Choose a random door 
    */
   def chooseADoor() : Int = {
      random.nextInt(numDoors)
   }
   
   /*  Choose an empty door -- avoiding the door that has the car.
    *  This method should avoid the guest's pick too
    */
   def chooseEmptyDoor() : Int = {
      val temp = random.nextInt(numDoors-1)
      
      val empty = if (temp < gameState.doorNum)
        temp
      else
        temp + 1
      chat("Here's an empty door: " + empty)
      empty
   }
   
   def win(door: Int) : Move = {
      val monty = "Monty Hall"
      if (door == gameState.doorNum)
        YouWon(monty)
      else
        YouLose(monty)
   }
}
