/* Demonstrate matching */

package net.slreynolds.talk

sealed abstract class Dog(name:String) 
case class Mixed(name:String) extends Dog(name)
case class Poodle(name:String) extends Dog(name)
case class AmericanEskimo(name:String) extends Dog(name)
case class Beagle(name:String) extends Dog(name)

object kennel {
    def feed(dog:Dog) = {
        dog match {
            case d: Mixed => 
                      print("fed " + d + " chicken\n")
            case AmericanEskimo("Samantha") => 
                      println("fed Samantha peas and carrots")
            case Poodle(n) => 
                      println(n + " rejected chicken, peas and carrots")
            case Beagle(n) if n.startsWith("Scoob") => 
                      println("fed " + n + " anything on the counter")
            case _ => println("fed " + dog + " some dog food\n")
        }
    } 
}

object DogsEx {
    def main(args: Array[String]) :Unit = {
        val bc = Mixed("BC")
        val sam = AmericanEskimo("Samantha")
        val noel = Poodle("Noel")
        val scooby = Beagle("Scooby")
        kennel.feed(bc)
        kennel.feed(sam)
        kennel.feed(noel)
        kennel.feed(scooby)
    }
}
