/* Demonstrate Functions */
package net.slreynolds.talk

object FP {
    // A Function
    val charValidatorFun = (in: Char) => 
      if ('!' <= in && in <= 'z')
        in
      else
        '-'
  
    // A method that can be used as a Function
    def charValidatorMethod(in: Char): Char = {
      if ('!' <= in && in <= 'z')
        in
      else
        '-'
    }
    
    // Uses a function as second argument
    def toFileName(baseName: String, validate: Char => Char) : String = {
      val validBaseName = baseName.map(validate)
      validBaseName.toLowerCase + ".txt"
    }

    def main(args : Array[String]) : Unit = {
      // Use an inline function
      val fileName1 = toFileName("L~{oLo",(in: Char) =>
      if ('!' <= in && in <= 'z')
        in
      else
        '-')  
      println("file name 1 is " + fileName1)
      
      // Use a val for the function
      val fileName2 = toFileName("B~{oBo",charValidatorFun)
      println("file name 2 is " + fileName2)
      
      // Use a method for the function
      val fileName3 = toFileName("W~{aCKo",charValidatorMethod)
      println("file name 3 is " + fileName3)
    }
}
