/* Compare traits to multiple inheritance */

package net.slreynolds.talk

class Person(name:String) {
    private val _name = name
    def to_string = _name
}

class Student(name:String, major:String) extends Person(name) {
    private var _major = major
    override def to_string = super.to_string + " " + _major
}

trait Worker {
    protected var _salery:Double = 0
    def getAnualSalery = _salery*40*52
}

class StudentWorker(name:String, major:String, salery:Double) 
                       extends Student(name,major) with Worker  {
    _salery = salery
    override def to_string = super.to_string + " " + getAnualSalery
}

object StudentWorkerEx {
    def main(args: Array[String]) :Unit = {
        val joe = new StudentWorker("joe","computer science",10)
        println(joe.to_string)
    }

}
